<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
[content_type:'text/html; charset=UTF-8']
<head>
	<meta http-equiv="content-type" content="text/html; charset=utf-8" />
	<title>Examples Pack - Collaborate</title>
	<?LassoScript
	// Include the library file which contains many of the tags 
	// that are utilized in these examples.
	library((string_replaceregexp: response_path, -find='(.*/).*?/', -replace='\\1') + 'library.lasso');
	// Include the library file which creates the required databases, tables and groups
	library('initialize.lasso');
	?>
	<script src="collaborate.js" type="text/javascript"></script>
	<style type="text/css">
		[include: 'edit/style.lasso']
	</style>
</head>
<body>
	<?LassoScript
		
		// Store the inputs to the page in variables.  The inputs include the 'section'
		// and 'page' which should be shown to the site visitor.  The 'mode' which can be
		// set to 'edit' in order to show the administration interface.  And, the 'action'
		// which is used within the administration interface on each submitted form.
		
		var: 'section' = (action_param: 'section', (action_param: 'section', -count));
		var: 'page' = (action_param: 'page', (action_param: 'page', -count));
		var: 'mode' = (action_param: 'mode', (action_param: 'mode', -count));
		var: 'action' = (action_param: 'action', (action_param: 'action', -count));
		
		// The variable 'handled' is set to true by one of the invidividual solution pages
		// when it has successfully handled the current request.  If none of the administration
		// pages handle the request then the page is shown using 'template.lasso' to the site
		// visitor.
		
		var: 'handled' = false;

		// Only an administrator or a member of the group 'OP Collaborate Admins' can access the
		// edit interface.  If the mode is 'edit' we prompt for their username and password.

		auth_group: (array: 'Administrators', 'OP Collaborate Admins');
		
		// Create a new page if mode is 'edit' and 'page' is set to '$new$'.
		
		if: ($handled == false) && ($page == '$new$');
			var: 'content' = (include: 'edit/page_new.lasso');
		/if;
		
		// Edit a page if mode is 'edit' and page is not empty.
		
		if: ($handled == false) && ($page != '');
			var: 'content' = (include: 'edit/page_edit.lasso');
		/if;
		
		// Create a new section if mode is 'edit' and 'section' is set to '$new$'.

		if: ($handled == false) && ($section == '$new$');
			var: 'content' = (include: 'edit/section_new.lasso');
		/if;

		// Edit a section if mode is 'edit' and section is not empty.
		
		if: ($handled == false) && ($section != '');
			var: 'content' = (include: 'edit/section_edit.lasso');
		/if;
		
		// Edit the global preferences if mode is 'edit' and both page and section are empty.
		
		if: ($handled == false);
			var: 'content' = (include: 'edit/site_edit.lasso');
		/if;
		
		if: ($handled == false);
			var: 'url' = 'index.lasso';
			var: 'params' = (array);
			if: $section != '';
				$params->(insert: 'section=' + (encode_stricturl: $section));
			/if;
			if: $page != '';
				$params->(insert: 'page=' + (encode_stricturl: $page));
			/if;
			if: $params->size > 0;
				$url += '?' + $params->(join: '&');
			/if;
			redirect_url: $url;
		/if;
		
		// If an error occurred then the error page is shown
		if: (error_msg != error_noerror);
			var: 'content' = (include: 'error.lasso');
		/if;
	
		// Show the content that was created by the include above
		$content;
		
		'<div style="clear: both;"><br /></div>';
		
		// include the footer that is shared by the examples
		include((string_replaceregexp: response_path, -find='(.*/).*?/', -replace='\\1') + 'examples_footer.lasso');
	?>
</body>
</html>
